package com.android.browser;

import android.util.Log;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 * Thread dedicated on sending messages to the Platform to send joins
 *
 * Updated by wseme on 9/3/13.
 */
public class OpenBrowserJoinThread extends Thread{

    private static final String IP_ADDRESS = "localhost";
    private static final int PORT = 49305;//DEFAULT BROWSER PORT
    private static final String TAG = "Open Browser Join Thread";

    private Socket socket;

    @Override
    public void run(){

        if(connect()){
            send(createDigitalCrestNet());
        }

        close();
    }


    /**
     * Just sending results, try once, else fail
     * @return
     */
    private boolean connect() {

        try {
            socket = new Socket(IP_ADDRESS, PORT);
            if (socket != null && socket.isConnected()) {
                return true;
            }
        } catch (UnknownHostException e) {
            Log.e(TAG, "Make sure socket host address is correct", e);
        } catch (IOException e) {
            Log.e(TAG, "Make sure server socket is available", e);
        }

        return false;
    }



    private byte[] createDigitalCrestNet(){

        byte[] buffer = new byte[9];

        byte cipBytesToFollow     = (byte)(6);
        byte cresnetBytesToFollow = (byte)(3);

        //CIP HEADER
        buffer[0]= 0x05;
        buffer[1]= 0x00;
        buffer[2]= cipBytesToFollow;//bytes to follow
        buffer[3]= 0x00;
        buffer[4]= 0x00;

        //CRESNET HEADER
        buffer[5]= cresnetBytesToFollow;//bytes to follow
        buffer[6]= 0x00;//type digital
        
        buffer[7]= (byte) 0xB7;
        buffer[8]= (byte) 0x6F;//6F is pressed, EF on release
        
        return buffer;
    }

    private void send(byte[] buffer){

        OutputStream bos;

        if(socket == null){
            return;
        }

        try {
            bos = socket.
                    getOutputStream();

            bos.write(buffer);
            bos.flush();

        } catch (IOException e) {
            Log.e(TAG, "Make sure server socket is available", e);
        }

    }
    /**
     * Close socket connection
     */
    private void close() {
        if (socket != null) {
            try {
                socket.getInputStream().close();
                socket.close();
            } catch (IOException e) { 
                // I/0 don't care! I/0 love it
            }
            socket = null;
        }

    }


}